/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl;

import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.LegacyResourceLoader;
import com.ibm.hwmca.fw.servlet.pmod.impl.ResourceLoaderResult;
import com.ibm.hwmca.fw.servlet.pmod.impl.ResourceLookupInputSource;
import com.ibm.hwmca.fw.util.Trace;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class LegacyResourceLookupInputSource
extends ResourceLookupInputSource {
    private static final String TRACE_MASKF = "XPMILRLF";
    protected String dataGroup = null;
    protected Properties utmProperties = null;

    public LegacyResourceLookupInputSource(String resourceName, Locale[] locales, String dataGroup, Properties utmProperties) {
        super(resourceName, locales);
        Trace.trace(TRACE_MASKF, "LegacyResourceLookupInputSource <ctor> res='" + resourceName + "', dg='" + dataGroup + "'");
        this.dataGroup = dataGroup;
        this.utmProperties = utmProperties;
    }

    public LegacyResourceLookupInputSource(String resourceName, Locale[] locales, String dataGroup) {
        this(resourceName, locales, dataGroup, null);
    }

    public InputStream getInputStream() throws PanelModelException {
        InputStream toReturn = null;
        if (this.dataGroup == null) {
            try {
                toReturn = super.getInputStream();
            }
            catch (PanelModelException e) {
                toReturn = null;
            }
        }
        String unadornedResourceName = this.resourceName;
        if (toReturn == null) {
            if (this.dataGroup == null) {
                throw new PanelModelException("Unable to locate specified resource: '" + unadornedResourceName + "'");
            }
            try {
                this.resourceName = this.resourceName + "$" + this.dataGroup;
                toReturn = super.getInputStream();
            }
            catch (PanelModelException e) {
                toReturn = null;
            }
        }
        this.resourceName = unadornedResourceName;
        if (toReturn == null) {
            ResourceLoaderResult resourceLoaderResult;
            Trace.trace(TRACE_MASKF, "LegacyResourceLookupInputSource getInputStream() NOT resolved by super.");
            ResourceLoaderResult resourceLoaderResult2 = resourceLoaderResult = this.utmProperties == null ? LegacyResourceLoader.getMarkupResource(this.resourceName, this.dataGroup) : LegacyResourceLoader.getMarkupResource(this.resourceName, this.dataGroup, this.utmProperties);
            if (resourceLoaderResult == null) {
                throw new PanelModelException("Unable to locate specified legacy resource: '" + this.resourceName + "'");
            }
            this.strata = "Strata:legacyPanel";
            this.source = resourceLoaderResult.getSource();
            toReturn = resourceLoaderResult.getStream();
        } else {
            Trace.trace(TRACE_MASKF, "LegacyResourceLookupInputSource getInputStream() resolved by super.");
        }
        return toReturn;
    }
}

